#"@(#)00   1.3   src/rsct/registry/ext/CT/SRrc/SRrc.pm, srcli, rsct_rori, roris01a 3/11/01 17:55:27"
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2000,2001 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

package CT::SRrc;

use strict;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $AUTOLOAD);

require Exporter;
require DynaLoader;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
    SR_ACKNOWLEDGE
    SR_ALL_METADATA_INVALID
    SR_CANNOT_ALTER_KEY
    SR_CANNOT_MALLOC
    SR_CANNOT_MOUNT_TO_EXISTING_MOUNT_POINT
    SR_CANNOT_SET_ROW_CHANGE_FIELD
    SR_CANNOT_WRITE
    SR_COL_TYPE_ERROR
    SR_CONNECTION_LOST
    SR_CONNECTION_REFUSED
    SR_COULD_NOT_LOCK
    SR_COULD_NOT_UNLOCK
    SR_DIRECTORY_EXISTS
    SR_DIRECTORY_NOT_EMPTY
    SR_DOWN
    SR_DUPLICATE_COLUMN
    SR_DUPLICATE_ENTRY
    SR_DUPLICATE_HANDLE
    SR_DUPLICATE_KEY
    SR_ENTRY_EXISTS
    SR_FILE_LSEEK_ERROR
    SR_FILE_OPEN_ERROR
    SR_FILE_STAT_ERROR
    SR_FILE_WRITE_ERROR
    SR_ILLEGAL_FOREIGN_KEY
    SR_ILLEGAL_NAME
    SR_ILLEGAL_OPERATION
    SR_ILLEGAL_SELECTION_STRING
    SR_INCONSISTENT_FILE_COPIES
    SR_INVALID_BLOCKING_FLAG
    SR_INVALID_COLUMN
    SR_INVALID_DIRECTORY
    SR_INVALID_FORCE
    SR_INVALID_HANDLE
    SR_INVALID_KEY
    SR_INVALID_LOCKID
    SR_INVALID_MODE
    SR_INVALID_OP
    SR_INVALID_OPCODE
    SR_INVALID_OVERWRITE
    SR_INVALID_PATHNAME
    SR_INVALID_RECURSIVE
    SR_INVALID_RETURN_CODE
    SR_INVALID_ROW_INDEX
    SR_INVALID_SERVER_RESULT
    SR_INVALID_STORAGE
    SR_INVALID_TABLE_HANDLE
    SR_INVALID_TREE
    SR_IS_DELETED
    SR_KEY_EXPECTED
    SR_KEY_NOT_ESTABLISHED
    SR_KEY_NOT_FOUND
    SR_LOCK_RELEASED
    SR_MEMCPY_ERROR
    SR_MEMORY_ERROR
    SR_MEMORY_NOT_INITIALIZED
    SR_MEMORY_SYNC_ERROR
    SR_MMAP_ERROR
    SR_MUTEX_LOCK_FAILED
    SR_NOT_ENOUGH_MEMORY
    SR_NOT_IMPLEMENTED
    SR_NOT_IN_LOCK_SET
    SR_NO_COLUMN
    SR_NO_CONNECTION
    SR_NO_DATA
    SR_NO_DIRECTORY
    SR_NO_ENTRY
    SR_NO_PARENT
    SR_NO_PERMISSION
    SR_NO_PERMISSION_SO
    SR_NO_PERMISSION_TA
    SR_NO_SERVER
    SR_NO_SERVER_LIST
    SR_NO_SERVER_RESULT
    SR_NO_TABLE
    SR_NO_TABLE_FIRST
    SR_NO_TABLE_SECOND
    SR_NULL_PARAMETER
    SR_NULL_POINTER
    SR_OUTSTANDING_USERS
    SR_OUT_OF_LOCK_SET
    SR_PERSISTENT_UNDER_TRANSIENT
    SR_REPLIC_GENERAL_ERROR
    SR_REPLIC_LIST_CORRUPTED
    SR_REPLIC_NO_QUORUM
    SR_SERVER_LIST_MISMATCH
    SR_SERVER_LIST_SIZE_MISMATCH
    SR_SE_COULD_NOT_EVAL
    SR_SE_EXTRA_CHARS
    SR_SE_ILLEGAL_COLUMN_NAME
    SR_SE_ILLEGAL_NUMERIC_CONSTANT
    SR_SE_ILLEGAL_RANGE
    SR_SE_ILLEGAL_RANGE_LIST
    SR_SE_ILLEGAL_REGEX
    SR_SE_ILLEGAL_SELECTION_STRING
    SR_SE_ILLEGAL_STRING_CONSTANT
    SR_SE_INVALID_COMPARISON
    SR_SE_INVALID_OPERATOR
    SR_SE_INVALID_TYPE_VARIABLE
    SR_SE_NO_COLUMN
    SR_SE_NO_VAR_PARAMETER
    SR_SE_NULL_NUMERIC_CONSTANT
    SR_SE_NULL_STRING_CONSTANT
    SR_SE_UNMATCHING_PARENTHESIS
    SR_SE_UNMATCHING_TYPE_VARIABLE
    SR_SOCK_CONNECT_ERROR
    SR_SOCK_CREATE_ERROR
    SR_SUCCESS
    SR_TABLES_LOCKED
    SR_TABLE_EXISTS
    SR_TOPOLOGY_MISMATCH
    SR_TRANSACTION_ABORTED
    SR_TRANSIENT_SUBDIRECTORY
    SR_UNMAP_ERROR
    SR_UNMATCHING_SEARCH_PARAM
);
$VERSION = '0.01';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.  If a constant is not found then control is passed
    # to the AUTOLOAD in AutoLoader.

    my $constname;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "& not defined" if $constname eq 'constant';
    my $val = constant($constname, @_ ? $_[0] : 0);
    if ($! != 0) {
    if ($! =~ /Invalid/) {
        $AutoLoader::AUTOLOAD = $AUTOLOAD;
        goto &AutoLoader::AUTOLOAD;
    }
    else {
        croak "Your vendor has not defined SRrc macro $constname";
    }
    }
    no strict 'refs';
#    *$AUTOLOAD = sub () { $val };
    $AUTOLOAD = sub () { $val };
    goto &$AUTOLOAD;
}

bootstrap CT::SRrc $VERSION;

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__


=head1 NAME

CT::SRrc - Perl extensions for RSCT SR ct_sr_rc.h


=head1 SYNOPSIS

use CT::SRrc;


=head1 DESCRIPTION

This extension is used by the Reliable Scalable Cluster Technology
(RSCT) System Registry (SR) Commands.
The SRrc extension contains all System Registry return codes.

The Perl to C Extensions for RSCT SR,
CT::SRrc, are not being externalized at this time.
Use at your own risk!
The API to these extensions will probably change.


=head1 EXPORTED CONSTANTS

For more information regarding these exported constants see the file:
    /usr/include/rsct/ct_sr_rc.h 

    SR_ACKNOWLEDGE
    SR_ALL_METADATA_INVALID
    SR_CANNOT_ALTER_KEY
    SR_CANNOT_MALLOC
    SR_CANNOT_MOUNT_TO_EXISTING_MOUNT_POINT
    SR_CANNOT_SET_ROW_CHANGE_FIELD
    SR_CANNOT_WRITE
    SR_COL_TYPE_ERROR
    SR_CONNECTION_LOST
    SR_CONNECTION_REFUSED
    SR_COULD_NOT_LOCK
    SR_COULD_NOT_UNLOCK
    SR_DIRECTORY_EXISTS
    SR_DIRECTORY_NOT_EMPTY
    SR_DOWN
    SR_DUPLICATE_COLUMN
    SR_DUPLICATE_ENTRY
    SR_DUPLICATE_HANDLE
    SR_DUPLICATE_KEY
    SR_ENTRY_EXISTS
    SR_FILE_LSEEK_ERROR
    SR_FILE_OPEN_ERROR
    SR_FILE_STAT_ERROR
    SR_FILE_WRITE_ERROR
    SR_ILLEGAL_FOREIGN_KEY
    SR_ILLEGAL_NAME
    SR_ILLEGAL_OPERATION
    SR_ILLEGAL_SELECTION_STRING
    SR_INCONSISTENT_FILE_COPIES
    SR_INVALID_BLOCKING_FLAG
    SR_INVALID_COLUMN
    SR_INVALID_DIRECTORY
    SR_INVALID_FORCE
    SR_INVALID_HANDLE
    SR_INVALID_KEY
    SR_INVALID_LOCKID
    SR_INVALID_MODE
    SR_INVALID_OP
    SR_INVALID_OPCODE
    SR_INVALID_OVERWRITE
    SR_INVALID_PATHNAME
    SR_INVALID_RECURSIVE
    SR_INVALID_RETURN_CODE
    SR_INVALID_ROW_INDEX
    SR_INVALID_SERVER_RESULT
    SR_INVALID_STORAGE
    SR_INVALID_TABLE_HANDLE
    SR_INVALID_TREE
    SR_IS_DELETED
    SR_KEY_EXPECTED
    SR_KEY_NOT_ESTABLISHED
    SR_KEY_NOT_FOUND
    SR_LOCK_RELEASED
    SR_MEMCPY_ERROR
    SR_MEMORY_ERROR
    SR_MEMORY_NOT_INITIALIZED
    SR_MEMORY_SYNC_ERROR
    SR_MMAP_ERROR
    SR_MUTEX_LOCK_FAILED
    SR_NOT_ENOUGH_MEMORY
    SR_NOT_IMPLEMENTED
    SR_NOT_IN_LOCK_SET
    SR_NO_COLUMN
    SR_NO_CONNECTION
    SR_NO_DATA
    SR_NO_DIRECTORY
    SR_NO_ENTRY
    SR_NO_PARENT
    SR_NO_PERMISSION
    SR_NO_PERMISSION_SO
    SR_NO_PERMISSION_TA
    SR_NO_SERVER
    SR_NO_SERVER_LIST
    SR_NO_SERVER_RESULT
    SR_NO_TABLE
    SR_NO_TABLE_FIRST
    SR_NO_TABLE_SECOND
    SR_NULL_PARAMETER
    SR_NULL_POINTER
    SR_OUTSTANDING_USERS
    SR_OUT_OF_LOCK_SET
    SR_PERSISTENT_UNDER_TRANSIENT
    SR_REPLIC_GENERAL_ERROR
    SR_REPLIC_LIST_CORRUPTED
    SR_REPLIC_NO_QUORUM
    SR_SERVER_LIST_MISMATCH
    SR_SERVER_LIST_SIZE_MISMATCH
    SR_SE_COULD_NOT_EVAL
    SR_SE_EXTRA_CHARS
    SR_SE_ILLEGAL_COLUMN_NAME
    SR_SE_ILLEGAL_NUMERIC_CONSTANT
    SR_SE_ILLEGAL_RANGE
    SR_SE_ILLEGAL_RANGE_LIST
    SR_SE_ILLEGAL_REGEX
    SR_SE_ILLEGAL_SELECTION_STRING
    SR_SE_ILLEGAL_STRING_CONSTANT
    SR_SE_INVALID_COMPARISON
    SR_SE_INVALID_OPERATOR
    SR_SE_INVALID_TYPE_VARIABLE
    SR_SE_NO_COLUMN
    SR_SE_NO_VAR_PARAMETER
    SR_SE_NULL_NUMERIC_CONSTANT
    SR_SE_NULL_STRING_CONSTANT
    SR_SE_UNMATCHING_PARENTHESIS
    SR_SE_UNMATCHING_TYPE_VARIABLE
    SR_SOCK_CONNECT_ERROR
    SR_SOCK_CREATE_ERROR
    SR_SUCCESS
    SR_TABLES_LOCKED
    SR_TABLE_EXISTS
    SR_TOPOLOGY_MISMATCH
    SR_TRANSACTION_ABORTED
    SR_TRANSIENT_SUBDIRECTORY
    SR_UNMAP_ERROR
    SR_UNMATCHING_SEARCH_PARAM




=head1 AUTHOR

Licensed Materials - Property of IBM
 
(C) COPYRIGHT International Business Machines Corp. 2000, 2001.
All Rights Reserved.

US Government Users Restricted Rights - Use, duplication or
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.


=head1 VERSION

RSCT Version 2.2


=head1 SEE ALSO

CT::CT, CT::SR

=cut
